<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Intent extends Model 
{

    protected $table = 'intents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'statut', 'add_by');
    protected $visible = array('name', 'statut', 'add_by');

    public function questions()
    {
        return $this->hasMany('App\Models\Question', 'id_intent');
    }

    public function reponses()
    {
        return $this->hasMany('App\Models\Reponse', 'id_intent');
    }

    public function create_by()
    {
        return $this->belongsTo('App\Models\User', 'add_by');
    }

}